function [S4,S31,S22a,S22b,S211a,S211b,S1111] = symmetries(x)
% compute all the symmetric quantities of order 4
% Input:
%   x [d,N] N vectors
N = size(x,2);
% Permutation 1: S4
S4_sum = 0;
P1 = permsk(1:N,1); 
n_P1 = size(P1,1);
for n = 1:n_P1
    i = P1(n,:); % [1]
    xi = x(:,i);
    S4_sum = S4_sum + dot(xi,xi)^2;
end
S4 = S4_sum / n_P1;
% Permutation 2: S31, S22a, S22b
S31_sum = 0;
S22a_sum = 0;
S22b_sum = 0;
P2 = permsk(1:N,2);
n_P2 = size(P2,1);
for n = 1:n_P2
    ij = P2(n,:); % [2]
    i = ij(1); j = ij(2);
    xi = x(:,i); xj = x(:,j);
    S31_sum = S31_sum + dot(xi,xi)*dot(xi,xj);
    S22a_sum = S22a_sum + dot(xi,xi)*dot(xj,xj);
    S22b_sum = S22b_sum + dot(xi,xj)^2;
end
S31 = S31_sum / n_P2;
S22a = S22a_sum / n_P2;
S22b = S22b_sum / n_P2;
% Permutation 3: S211a, S211b
S211a_sum = 0;
S211b_sum = 0;
P3 = permsk(1:N,3);
n_P3 = size(P3,1);
for n = 1:n_P3
    ijk = P3(n,:); % [3]
    i = ijk(1); j = ijk(2); k = ijk(3);
    xi = x(:,i); xj = x(:,j); xk = x(:,k);
    S211a_sum = S211a_sum + dot(xi,xi)*dot(xj,xk);
    S211b_sum = S211b_sum + dot(xi,xj)*dot(xi,xk);
end
S211a = S211a_sum / n_P3;
S211b = S211b_sum / n_P3;
% Permutation 4: S1111
S1111_sum = 0;
P4 = permsk(1:N,4);
n_P4 = size(P4,1);
for n = 1:n_P4
    ijkl = P4(n,:); % [3]
    i = ijkl(1); j = ijkl(2); k = ijkl(3); l = ijkl(4);
    xi = x(:,i); xj = x(:,j); xk = x(:,k); xl = x(:,l);
    S1111_sum = S1111_sum + dot(xi,xj)*dot(xk,xl);
end
S1111 = S1111_sum / n_P4;
end